/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="pizzacraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PizzaCraftConfig {
    public static boolean generateOliveTree;
    public static boolean dropOliveFromJungleLeaves;
    public static boolean seedDrops;
    private static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == commonSpec) {
            PizzaCraftConfig.bakeCommonConfig();
        }
    }

    public static void bakeCommonConfig() {
        generateOliveTree = (Boolean)PizzaCraftConfig.COMMON.generateOliveTree.get();
        dropOliveFromJungleLeaves = (Boolean)PizzaCraftConfig.COMMON.dropOliveFromJungleLeaves.get();
        seedDrops = (Boolean)PizzaCraftConfig.COMMON.seedDrops.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue generateOliveTree;
        public final ForgeConfigSpec.BooleanValue dropOliveFromJungleLeaves;
        public final ForgeConfigSpec.BooleanValue seedDrops;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            this.generateOliveTree = builder.translation("pizzacraft.config.common.generateolivetree").define("generateOliveTree", true);
            this.dropOliveFromJungleLeaves = builder.translation("pizzacraft.config.common.dropolivefromjungleleaves").define("dropOliveFromJungleLeaves", false);
            this.seedDrops = builder.translation("pizzacraft.config.common.seeddrops").define("seedDrops", true);
            builder.pop();
        }
    }
}

